local P2xpos;
local P2ypos;
local P1,P2;
local counter
local songName= GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song
local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()


local function handler_mod_internal(str, pn) -- Aplies Players options to not be disabled-
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local WideScale = function(AR4_3, AR16_9)
	-- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
	local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
	return scale( w, 640, 854, AR4_3, AR16_9 )
 end

local function handler_mod(str) -- Looks for many players are on the screen
	for i=1,2 do
		handler_mod_internal(str, 'PlayerNumber_P' .. i)
	end
end

local function handler_init() -- Useful for command shorcuts
	fgcurcommand = 0;
	wndr_skewx=0.3;
	checked = false;
	
	--lua course :D	/ timed mod management	
	curmod = 1;
	--{beat,'mod'},
	mods = {
		{1, '*1 20% dark, *2 70% stealth, *10 100% Beat, *5 60% mini'}
	}


	--SCREAMING GUMBALL / timed message broadcaster
	curmessage = 1;
	--{beat,message,ignoreIfAhead}
	messages = {
	--intro
    {1, 'Loop'},
	{127.75, 'Flash'},
	{191, 'Normal'},
	{255.75, 'Flash2'},
	{319, 'Normal'},
	{351.75, 'Flash3'},
	{415.5, 'Normal2'}
	

	}
    Players = {}
    prefix_inc = 1

end
local beat
local function handler_update() -- Updates the command to look for the players at the start of the song.

	if GAMESTATE:GetSongBeat()>=0.1 and not checked then
        prefix_inc = prefix_inc + 1;
		--PE = SCREENMAN:GetTopScreen():GetChild('')
		
		screen = SCREENMAN:GetTopScreen()
		
		checked = true;
		
	end


	beat = GAMESTATE:GetSongBeat()

	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		handler_mod(total_mod_str)
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][3] and GAMESTATE:GetSongBeat()>=messages[curmessage][1]+5 then
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1;
		end
	end
end
return Def.ActorFrame{

	OnCommand= function(self)
			handler_init()
			self:SetUpdateFunction(handler_update)

			-- Fade out everything but the SongBackground, SongForeground, and Player layers.
			-- In Simply Love (as of v4.8.5 anyway), player combos will unhide themselves,
			-- but that's okay for this stepchart.  If you need to hide combos in SL, call
			-- hibernate(math.huge) on each.  Sorry about that.
			-- don't fade out the theme's UI in EditMode
			-- Below was originally snipped From Watermelon by quietly-turning
			SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
			SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
			if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
				table.insert(Players,SCREENMAN:GetTopScreen():GetChild('PlayerP1'));
			end
			if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
				table.insert(Players,SCREENMAN:GetTopScreen():GetChild('PlayerP2'));
			end
			for i,v in pairs(Players) do
				if v then
					SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(true);
					SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(true);
				end
			end

		end,
		LoadActor("BG.mp4")..{
			OnCommand=function(self)
				local src_w = self:GetTexture():GetSourceWidth()
				self:Center():zoom(_screen.w/WideScale(src_w*0.75,src_w))
				self:animate(false):loop(false):rate(0):visible(false):diffusealpha(0.4)
			end,
			FlashMessageCommand=function(self)
				self:animate(true):loop(true):rate(musicrate):visible(true):diffusealpha(0.5)
			end,
			Flash2MessageCommand=function(self)
				self:animate(true):loop(true):rate(musicrate):visible(true):diffusealpha(0.5):rainbow():effectperiod(30)
			end,
			Flash3MessageCommand=function(self)
				self:animate(true):loop(true):rate(musicrate):visible(true):diffusealpha(0.8):rainbow():effectperiod(50)
			end,	
			Normal2MessageCommand=function(self)
				self:linear(8):zoom(10)
			end	,
			NormalMessageCommand=function(self)
				self:linear(2):diffusealpha(0)
			end
		},
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
	Def.Sprite{
		Texture ='rose';
		InitCommand = function(self) eye= self; end;
		FlashMessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,60)
		end,
		Flash2MessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,90)
		end,
		NormalMessageCommand=function(self)
			self:linear(2):diffusealpha(0):spin():effectmagnitude(0,0,-25)
		end,
		OnCommand = function(self)
			self:visible(true)
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y)
			self:zoom(0.1):diffusealpha(0)

			self:spin():effectmagnitude(0,0,-25)
		end,
	},
	Def.Sprite{
		Texture ='rose';
		InitCommand = function(self) eye= self; end;
		FlashMessageCommand=function(self)
			self:diffusealpha(0.3):spin():effectmagnitude(0,0,-60)
		end,
		Flash2MessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,-95)
		end,
		NormalMessageCommand=function(self)
			self:linear(2):diffusealpha(0.2):spin():effectmagnitude(0,0,-25)
		end,
		OnCommand = function(self)
			self:visible(true)
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y)
			self:zoom(0.85):diffusealpha(0.2)
			self:spin():effectmagnitude(0,0,-25)
		end,
	},
	Def.Sprite{
		Texture ='rose';
		InitCommand = function(self) eye= self; end;
		FlashMessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,80)
		end,
		Flash2MessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,150)
		end,
		NormalMessageCommand=function(self)
			self:linear(2):diffusealpha(0):spin():effectmagnitude(0,0,-25)
		end,
		Flash3MessageCommand=function(self)
			self:zoom(0.25+math.sin(-1 * beat *math.pi/12)*2):diffusealpha(0.2):spin():effectmagnitude(0,0,50)
			self:sleep(0.0266666);
      --      self:queuemessage('FlashGordon');	
		end,
		FlashGordonMessageCommand=function(self)
			--self:linear(0.5):zoom(0.5+math.sin(beat *math.pi/12))				
			self:sleep(0.0266666);
            self:queuemessage('FlashGordon');
		end,
		OnCommand = function(self)
			self:visible(true)
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y)
			self:zoom(0.45):diffusealpha(0)
			self:spin():effectmagnitude(0,0,-25)
		end,
	},
	Def.Sprite{
		Texture ='rose';
		InitCommand = function(self) eye= self; end;
		FlashMessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,60)
		end,
		Flash2MessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,100)
		end,
		Flash3MessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,50)
		end,
		NormalMessageCommand=function(self)
			self:linear(2):diffusealpha(0):spin():effectmagnitude(0,0,-25)
		end,
		OnCommand = function(self)
			self:visible(true)
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y)
			self:zoom(1.22):diffusealpha(0)
			self:spin():effectmagnitude(0,0,-25)
		end,
	},
	Def.Sprite{
		Texture ='rose';
		InitCommand = function(self) eye= self; end;
		FlashMessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,-20)
		end,
		Flash2MessageCommand=function(self)
			self:diffusealpha(0.2):spin():effectmagnitude(0,0,-40)
		end,
		NormalMessageCommand=function(self)
			self:linear(2):diffusealpha(0):spin():effectmagnitude(0,0,-25)
		end,
		OnCommand = function(self)
			self:visible(true)
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y)
			self:zoom(2):diffusealpha(0)
			self:spin():effectmagnitude(0,0,-25)
		end,
	},
	Def.Quad{
		OnCommand= cmd(diffuse,0,0,0,1;diffusealpha,0;zoomto,6,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y),

		-- You can add MessageCommands here.
		-- These are applied by using the messages={ Section.
		StopMessageCommand= function(self)
			if P1 then
				P1:bounce():effectmagnitude(0,0,0);
			end
			if P2 then
				P2:stopeffect();
			end
		end,
        LoopMessageCommand = function(self)	
            local beat = GAMESTATE:GetSongBeat()
            local player, ang
            local freq = 8; if beat >= 0 then freq = -8; end
            local multi = 1; if math.mod(prefix_inc,2) == 0 then multi = -1; end
            for i,v in pairs(Players) do
                if v then
                    if i == 1 or i == 3 then
                        v:x(SCREEN_CENTER_X+math.cos(beat*math.pi/freq)*80*multi);
                        v:y(SCREEN_CENTER_Y+math.sin(beat*math.pi/freq)*80*multi);
                        v:rotationz(math.deg(beat*math.pi/freq)+90*multi);
                    elseif i == 2 then
                        v:x(SCREEN_CENTER_X+math.cos((beat+8)*math.pi/freq)*80*multi);
                        v:y(SCREEN_CENTER_Y+math.sin((beat+8)*math.pi/freq)*80*multi);
                        v:rotationz(math.deg((beat+8)*math.pi/freq)+90*multi);			
					end
                end
            end
        --	self:stoptweening():linear(0.0166666)
            self:sleep(0.0266666);
            self:queuemessage('Loop');			
        end,
        Loop2MessageCommand = function(self)	
            local beat = GAMESTATE:GetSongBeat()
            local player, ang
            if beat > 454 and beat < 484 then
                beat = (beat*.40)
                if P1 then
                    player = 1
                    ang = ((player-1)*math.pi)
                    P1:z(150*math.sin(beat*math.pi*0.5+ang))
                    P1:x(SCREEN_CENTER_X + SCREEN_WIDTH*-0.25*math.cos(beat*math.pi*0.5+ang))
                    --P1:rotationz(self:GetX()*(((player-1)*2)-1));
                    P1:skewx(0);
                end
                if P2 then
                    player = 2
                    ang = ((player-1)*math.pi)
                    P2:z(150*math.sin(beat*math.pi*0.5+ang))
                    P2:x(SCREEN_CENTER_X + SCREEN_WIDTH*-0.25*math.cos(beat*math.pi*0.5+ang))
                    --P2:rotationz(self:GetX()*(((player-1)*2)-1));
                    P2:skewx(0);
                end
            self:sleep(0.0566666);
            self:queuemessage('Loop2');			
            end
        end,
		BounceMessageCommand= function(self)		
			if P1 then
				P1:bounce():effectmagnitude(1,25,1):effectperiod(0.3871);
			end
			if P2 then
				P2:bounce():effectmagnitude(1,25,1):effectperiod(0.3871);
			end
		end,
		Bounce1MessageCommand= function(self)		
			if P1 then
				P1:bounce():effectmagnitude(1,35,1):effectperiod(0.3871);
			end
			if P2 then
				P2:bounce():effectmagnitude(1,35,1):effectperiod(0.3871);
			end
		end,
	},
	LoadActor("Wind.mp4")..{
		OnCommand=function(self)
			local src_w = self:GetTexture():GetSourceWidth()
			self:Center():zoom(_screen.w/WideScale(src_w*0.75,src_w))
			self:animate(false):loop(false):rate(0):visible(false)
		end,
		FlashMessageCommand=function(self)
			self:animate(true):loop(true):rate(musicrate):visible(true):diffusealpha(0.7)
		end,
		Flash2MessageCommand=function(self)
			self:animate(true):loop(true):rate(musicrate):visible(true):diffusealpha(0.4)
		end,
		Flash3MessageCommand=function(self)
			self:animate(true):loop(true):rate(musicrate):visible(true):diffusealpha(0.3)
		end,
		NormalMessageCommand=function(self)
			self:diffusealpha(0)
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P1Score and not isEditMode() then
				self:SetTarget(P1Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P2Score and not isEditMode() then
				self:SetTarget(P2Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if Players[1] then
				self:SetTarget(Players[1])
			end
		end,
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if Players[2] then
				self:SetTarget(Players[2])
			end
		end,
	},
	Def.Quad{
		FlashMessageCommand=function(self)
			self:FullScreen():Center()
			self:decelerate(0.03):linear(3)
			self:diffuse(0.1,0.1,0.2,0.1)
		end,
	},
	Def.Quad{
		NormalMessageCommand=function(self)
			self:FullScreen():Center()
			self:decelerate(0.03):linear(2)
			self:diffuse(0.1,0.1,0.2,0.1)
		end,
	},
	Def.Quad{
		Flash2MessageCommand=function(self)
			self:FullScreen():Center()
			self:decelerate(0.03):linear(2)
			self:diffuse(0.1,0.1,0.2,0.1)
		end,
	},
	Def.Quad{
		Flash3MessageCommand=function(self)
			self:FullScreen():Center()
			self:decelerate(0.03):linear(2)
			self:diffuse(0.1,0.1,0.2,0.1)
		end,
	},
}
